import json, glob, pandas as pd

# prefer summary CSV if it carries splus_hash; else read per-run JSONs
csvs = glob.glob(r"results_cc\summary*.csv")
if csvs:
    df = pd.read_csv(sorted(csvs)[-1])
    if "splus_hash" in df.columns:
        g = df.groupby(["gauge","L","b","kappa"])["splus_hash"].nunique()
        print("unique S+ hashes per (gauge,L,b,kappa):")
        print(g)
        df.to_csv("results_cc/summary_last.csv", index=False)
    else:
        print("No splus_hash in summary CSV; reading JSONs…")
        raise RuntimeError("no_splus")
else:
    raise RuntimeError("no_summary")
